@extends('layouts.layoutapp')

@section('content')
    <div class="main-content">
        <div class="row">
            <div class="col-12">
                <div class="card mb-4 mx-4">
                    <div class="card-header pb-0">
                        <div class="d-flex flex-row justify-content-between">
                            <div>
                                <h5 class="mb-0">All Order's</h5>
                            </div>
                            <a href="{{ route('orders-add') }}" class="btn bg-gradient-primary btn-sm mb-0">+&nbsp; Add
                                Order</a>
                        </div>
                    </div>

                    <div class="card-body px-0 pt-0 pb-2">
                        <div class="table-responsive p-0">
                            <table class="table align-items-center mb-0" id="myTable">
                                <thead>
                                    <tr>
                                        <th
                                            class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                            Order Id</th>
                                        <th
                                            class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                            Client</th>
                                        <th
                                            class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                            Order Date</th>
                                        <th
                                            class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                            Due Date</th>
                                        <th
                                            class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                            Amount</th>
                                        <th
                                            class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                            Status</th>
                                        <th
                                            class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                            Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach     ($orders as $data)
                                        <tr>
                                            <td class="ps-4 text-center">
                                                <p class="text-xs font-weight-bold mb-0">{{ $data->order_id ?? 'Order' }}</p>
                                            </td>
                                             <td class="ps-4 text-center">
                                                <p class="text-xs font-weight-bold mb-0">{{ $data->client->user->name ?? '' }}</p>
                                            </td>
                                            <td class="ps-4 text-center">
                                                <p class="text-xs font-weight-bold mb-0">
                                                    {{ $data->order_date ? \Carbon\Carbon::parse($data->order_date)->format('d-m-Y') : '' }}
                                                </p>
                                            </td>
                                            <td class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">
                                                    {{ $data->due_date ? \Carbon\Carbon::parse($data->due_date)->format('d-m-Y') : '' }}
                                                </p>
                                            </td>
                                            <td class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">{{ $data->final_amount }}</p>
                                            </td>
                                            <td class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">
                                                    @if($data->status == 1)
                                                        <span class="badge bg-info">Draft</span>
                                                    @elseif($data->status == 2)
                                                        <span class="badge bg-warning">Partially Completed</span>
                                                    @elseif($data->status == 3)
                                                        <span class="badge bg-success">Completed</span>
                                                    @endif
                                                </p>

                                            </td>
                                            <td class="text-center">
                                                <div class="d-flex justify-content-center align-items-center gap-3">

                                                    <a href="{{ route('orders-edit', ['id' => $data->id, 'type' => 'edit']) }}"
                                                        @if($data->oprntl_flag == 'C') style="pointer-events: none; opacity: 0.5;"
                                                        title="Edit Order (Disabled)" @endif>
                                                        <i class="fa-solid fa-pen-to-square text-secondary fa-lg ms-2"
                                                            title="Edit Order"></i>
                                                    </a>

                                                    @if (Auth::user()->user_flg !== 'C')

                                                        <a
                                                            href="{{ route('orders-edit', ['id' => $data->id, 'type' => 'convert']) }}">
                                                            <i class="fa-solid fa-money-bill-transfer text-secondary fa-lg ms-2"
                                                                title="Convert Order"></i>
                                                        </a>
                                                    @endif
                                                    <!-- Download Invoice -->
                                                    <a href="{{ route('order-pdf', $data->id) }}">
                                                        <i class="fa-solid fa-download text-secondary ms-2"
                                                            title="Download Invoice"></i>
                                                    </a>

                                                    @if (Auth::user()->user_flg !== 'C')

                                                        <span class="ms-2">
                                                            <form action="{{ route('orders-delete', $data->id) }}" method="POST"
                                                                class="d-inline" id="delete-form-{{$data->id}}">
                                                                @csrf
                                                                @method('DELETE')
                                                                <i class="fas fa-trash text-secondary fa-lg"
                                                                    @if($data->oprntl_flag == 'C')
                                                                        style="pointer-events: none; opacity: 0.5;"
                                                                        title="Delete Order (Disabled)" @else title="Delete Order"
                                                                    onclick="confirmDelete({{ $data->id }})" @endif>
                                                                </i>
                                                            </form>
                                                        </span>
                                                    @endif

                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@push('scripts')
    <script>
        function confirmDelete(id) {
            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Yes, delete it!',
                cancelButtonText: 'Cancel'
            }).then((result) => {
                if (result.isConfirmed) {
                    document.getElementById('delete-form-' + id).submit();
                }
            });
        }
    </script>
@endpush