
<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-12">
            <div class="card me-2">
                <!-- Card Header -->
                <div class="card-header pb-0">
                    <div class="d-flex flex-row justify-content-between">
                        <div>
                            <h5 class="mb-0">Admins</h5>
                        </div>
                        <a href="<?php echo e(route('admins-add')); ?>" class="btn bg-gradient-primary btn-sm mb-0">+&nbsp; New
                            Admin</a>
                    </div>
                </div>
                <div class="card-body px-0 pt-0 pb-2">
                    <div class="table-responsive p-0">
                        <table class="table align-items-center mb-0 table-hover" id="myTable">
                            <thead>
                                <tr>
                                    <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">ID
                                    </th>
                                    <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Name
                                    </th>
                                    <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                        Number</th>
                                    <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                        Email</th>
                                    <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Role
                                    </th>
                                    <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                        Status</th>
                                    <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                        Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $admins; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $admin): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td class="ps-4">
                                            <p class="text-xs font-weight-bold mb-0"><?php echo e($loop->iteration); ?></p>
                                        </td>
                                        <td class="ps-4">
                                            <p class="text-xs font-weight-bold mb-0"><?php echo e($admin->name); ?>

                                                <?php echo e($admin->last_name); ?>

                                            </p>
                                        </td>
                                        <td class="ps-4">
                                            <p class="text-xs font-weight-bold mb-0"><?php echo e($admin->phone); ?></p>
                                        </td>
                                        <td class="ps-4">
                                            <p class="text-xs font-weight-bold mb-0"><?php echo e($admin->email); ?></p>
                                        </td>
                                        <td class="ps-4">
                                            <p class="text-xs font-weight-bold mb-0">
                                                <?php echo e($admin->user_flg == "A" ? "Admin" : "Staff"); ?>

                                            </p>
                                        </td>
                                        <td class="ps-4">
                                            <p class="text-xs font-weight-bold mb-0">
                                                <?php echo e($admin->active_status == "A" ? "Active" : "Inactive"); ?>

                                            </p>
                                        </td>
                                        <td>
                                            <!-- Edit Icon -->
                                            <a href="<?php echo e(route('admins-edit', $admin->id)); ?>" data-bs-toggle="tooltip"
                                                data-bs-original-title="Edit Admin">
                                                <i class="fa-solid fa-pen-to-square text-secondary"></i>
                                            </a>

                                            <span class="ms-2">
                                                <!-- Delete Icon and Form -->
                                                <form action="<?php echo e(route('admins-delete', ['id' => $admin->id])); ?>" method="POST"
                                                    id="delete-form-<?php echo e($admin->id); ?>" class="d-inline">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <i class="fas fa-trash text-secondary" data-bs-toggle="tooltip"
                                                        data-bs-original-title="Delete Admin"
                                                        onclick="confirmDelete(<?php echo e($admin->id); ?>)"></i>
                                                </form>
                                            </span>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
    <script>
        function confirmDelete(id) {
            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Yes, delete it!',
                cancelButtonText: 'Cancel'
            }).then((result) => {
                if (result.isConfirmed) {
                    document.getElementById('delete-form-' + id).submit();
                }
            });
        }
    </script>
    <script>
        $('#myTable1').DataTable();
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.layoutapp', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /opt/lampp/htdocs/lara_commonbilling_new/resources/views/admins/index.blade.php ENDPATH**/ ?>