<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProductPaymentModel extends Model
{
    use HasFactory;

    protected $table = 'product_payments';
    protected $primaryKey = 'id';
    protected $fillable = [
        'product_dtl_id',
        'payment_type',
        'payment_date',
        'total_amount',
        'paid_amount',
        'type',
        'purchase_id'
    ];

    public $timestamps = true;

    public function product_dtls()
    {
        return $this->belongsTo(ProductDetailsModel::class, 'product_dtl_id', 'product_details_sid');
    }

    public function purchase()
{
    return $this->belongsTo(PurchaseModel::class, 'purchase_id');
}

}
